﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.POSRetail.Controls;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;
using AZVIC.Ei8htPOS.POSRetail.Helper;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Windows.Threading;

namespace AZVIC.Ei8htPOS.POSRetail.Pages
{
    /// <summary>
    /// Interaction logic for Login.xaml
    /// </summary>
    public partial class Login : Page
    {
        #region Variables
        private MasterWindow Master { get; set; }
        #endregion

        #region Constructor
        public Login()
        {
            InitializeComponent();
            Master = Application.Current.MainWindow as MasterWindow;
            Master.lblTimer.Foreground = Brushes.White;
            LoadUserDetails();
            Master.UpdateCustomerName();
            Master.ShowHideCopyrightInfo(false);
            //GlobalConfigurations.AppConfiguration.IsLocalDatabase = /*true;*/ !GlobalConfigurations.AppConfiguration.IsConnectedToInternet();           
        }

        private void LoadUserDetails()
        {
            //Properties.S
            txtUsername.Text = Properties.Settings.Default.UserName;
            txtPassword.Password = Properties.Settings.Default.Password;
            chkRememberme.IsChecked = (!string.IsNullOrEmpty(Properties.Settings.Default.UserName) && !string.IsNullOrEmpty(Properties.Settings.Default.Password));
            txtUsername.Focus();
        }
        #endregion

        #region Event Handlers
        /// <summary>
        /// Login Button Event Handler. This will be triggered when the user clicks the Login Button.
        /// </summary>
        /// <param name="sender">Sender Object - Login/Retry Button</param>
        /// <param name="e">Click Arguments</param>
        private void btnLogin_Click(object sender, RoutedEventArgs e)
        {
            if (btnLogin.Content.Equals(UIConstants.LOGIN))
            {
                if (Validate())
                {
                    ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, () =>
                    {
                        //AppSession.UserList = UserAccountBL.GetList(Guid.Empty, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
                        AppSession.ProductsList = ProductsBL.GetList(Guid.Empty, string.Empty).Where(a => a.IsActive).ToList<Products>();
                        bool IsConnectedToInternet = GlobalConfigurations.AppConfiguration.IsConnectedToInternet();
                        AppSession.ProductsList.OrderBy(product => product.SequenceNo).ToList().ForEach(product => product.Image1 = IsConnectedToInternet ?
                            (string.IsNullOrEmpty(product.Image1) ? AppSession.ImagePath + AppSession.NoImagePath : AppSession.ImagePath + product.Image1)
                            : (string.IsNullOrEmpty(product.Image1) ? AppSession.LocalImagePath + AppSession.NoImagePath : AppSession.LocalImagePath + product.Image1));
                        //!GlobalConfigurations.AppConfiguration.IsLocalDatabase ? string.IsNullOrEmpty(product.Image1) ? AppSession.NoImagePath : AppSession.ImagePath + product.Image1 : AppSession.LocalImagePath)

                        //AppSession.ProductsList.OrderBy(product => product.SequenceNo).ToList().ForEach(product => product.Image1 =
                        //   (string.IsNullOrEmpty(product.Image1) ? AppSession.NoImagePath : AppSession.ImagePath + product.Image1));

                        AppSession.CategoryList = ProductCategoryBL.GetList(Guid.Empty, string.Empty).Where(a => a.IsActive).OrderBy(category => category.SequenceNo).ToList<ProductCategory>();
                        AppSession.ProductSubCategoryList = ProductSubCategoryBL.GetList(Guid.Empty, Guid.Empty, string.Empty).Where(a => a.IsActive).OrderBy(scategory => scategory.SequenceNo).ToList<ProductSubCategory>();
                        AppSession.ProductsXCategoryList = ProductsXCategoryBL.GetList(Guid.Empty, Guid.Empty, Guid.Empty).Where(a => a.IsActive).ToList<ProductsXCategory>();
                        AppSession.BrandList = ProductBrandBL.GetList(Guid.Empty, string.Empty).Where(a => a.IsActive).OrderBy(brand => brand.SequenceNo).ToList<ProductBrand>();
                        AppSession.ColorList = ProductColorBL.GetList(Guid.Empty, string.Empty).Where(a => a.IsActive).OrderBy(color => color.SequenceNo).ToList<ProductColor>();
                        AppSession.MeasurementList = ProductMeasurementBL.GetList(Guid.Empty, string.Empty).Where(a => a.IsActive).OrderBy(size => size.SequenceNo).ToList<ProductMeasurement>();
                        AppSession.PromotionList = PromotionBL.GetList(Guid.Empty, DateTime.MinValue, DateTime.MinValue, string.Empty).Where(x => x.IsActive == true && (DateTime.Now >= x.StartDate && DateTime.Now <= x.EndDate)).ToList();

                        Action action = () =>
                        {
                            if (chkRememberme.IsChecked.Value)
                            {
                                Properties.Settings.Default.UserName = txtUsername.Text.Trim();
                                Properties.Settings.Default.Password = txtPassword.Password.Trim();
                                Properties.Settings.Default.Save();
                            }
                            else
                            {
                                Properties.Settings.Default.UserName = Properties.Settings.Default.Password = string.Empty;
                                Properties.Settings.Default.Save();
                            }
                        };

                        Dispatcher.BeginInvoke(DispatcherPriority.Send, action);
                    });

                    if (!result.OperationFailed)
                    {
                        CheckSalesClosed();

                        //rctBorder.Fill = new SolidColorBrush() { Color = Color.FromRgb(61, 181, 180) };
                    }
                    else
                        MessageBox.Show(result.Error.Message);
                }
                else
                {
                    ActivateControls(false);
                }
            }
            else
            {
                ActivateControls(true);
            }
        }
        #endregion

        private void CheckSalesClosed()
        {
            DateTime CurrentBusinessDay = LoadBusinessDay(DateTime.Now);
            Entities.DailySalesReport CurrentDayReport = DailySalesReportBL.GetItem(Guid.Empty, CurrentBusinessDay);
            if (CurrentDayReport != null && (!string.IsNullOrEmpty(CurrentDayReport.ReportStatus)))
            {
                if (CurrentDayReport.ReportStatus.ToLower().Equals("completed"))
                {
                    if (App.ConfirmationDialog("The sales for the day is closed. Do you want to open the sales again?", "Confirm Open Sales - Ei8ht POS"))
                    {
                        CurrentDayReport.CreatedBy = AppSession.CurrentAdminUser.UniqueID;
                        CurrentDayReport.ReportStatus = "Pending";
                        if (DailySalesReportBL.Save(CurrentDayReport))
                        {
                            Master.LoadPages(new Ordering(), Menus.ORDER);
                        }
                        else
                        {
                            App.ShowMessageBox("Problem in opening sales for transactions now.Please try after some time", "Confirm Open Sales - Ei8ht POS");
                            return;
                        }
                    }
                    else
                    {
                        return;
                    }
                }
                else
                {
                    Master.LoadPages(new Ordering(), Menus.ORDER);
                }
            }
            //No Report found
            else
            {
                OpeningDayBalance obj = new OpeningDayBalance();
                Entities.DailySalesReport LastDaySales = DailySalesReportBL.GetItem(Guid.Empty, CurrentBusinessDay.AddDays(-1));
                string LastDayBalance = string.Empty;
                if (LastDaySales != null)
                    LastDayBalance = LastDaySales.CashRegisterBalance.ToString("0.00");
                else
                    LastDayBalance = "0.00";
                string OpeningBalanceResp = OpeningDayBalance.Prompt(LastDayBalance);
                if (OpeningBalanceResp != null)
                {
                    decimal OpeningBalance = 0;
                    string VarinceRemarks = "";
                    if (OpeningBalanceResp.IndexOf('|') != -1)
                    {
                        OpeningBalance = decimal.Parse(OpeningBalanceResp.Substring(0, OpeningBalanceResp.IndexOf('|')));
                        VarinceRemarks = OpeningBalanceResp.Substring(OpeningBalanceResp.IndexOf("|") + 1, OpeningBalanceResp.Length - OpeningBalanceResp.IndexOf("|") - 1);
                    }

                    if (OpeningBalance != null)
                    {
                        Entities.DailySalesReport CurrentDayNewReport = new Entities.DailySalesReport();
                        CurrentDayNewReport.CreatedBy = AppSession.CurrentAdminUser.UniqueID;
                        CurrentDayNewReport.OpeningBalance = OpeningBalance;
                        CurrentDayNewReport.ReportStatus = "Pending";
                        CurrentDayNewReport.ReportDate = CurrentBusinessDay;
                        CurrentDayNewReport.OpeningRemarks = VarinceRemarks;
                        if (DailySalesReportBL.Save(CurrentDayNewReport))
                        {
                            Master.LoadPages(new Ordering(), Menus.ORDER);
                        }
                        else
                        {
                            App.ShowMessageBox("Problem in opening the sales.", "Ei8ht POS");
                        }
                    }
                    else
                    {
                        return;
                    }
                }
            }
        }

        private DateTime LoadBusinessDay(DateTime StartDate)
        {
            DateTime StartTime = DateTime.Parse(StartDate.ToShortDateString() + " " + AppSession.BusinessHourStart);
            DateTime EndTime = DateTime.Parse(StartDate.ToShortDateString() + " " + AppSession.BusinessHourEnd);
            if (StartTime > EndTime)
                EndTime = EndTime.AddDays(1);

            if (StartTime <= StartDate && StartDate <= EndTime)
            {
                return new DateTime(StartTime.Year, StartTime.Month, StartTime.Day, 0, 0, 0);
            }
            else
            {
                return new DateTime(StartTime.Year, StartTime.Month, StartTime.Day, 0, 0, 0).AddDays(-1);
            }
        }

        #region Private Methods
        /// <summary>
        /// This Method is used to Activate controls based on the success/failure of Validation. 
        /// </summary>
        /// <param name="ShowUserLogin">Show User Login Boolean flag is used to show/hide respective controls during validation success/failure. 
        /// Send this value as true - To show Login Controls. Send this as false to Show Error Message.</param>
        private void ActivateControls(bool ShowUserLogin)
        {
            chkRememberme.Visibility = ShowUserLogin ? Visibility.Visible : Visibility.Collapsed;
            imgFailure.Visibility = ShowUserLogin ? Visibility.Collapsed : Visibility.Visible;
            lblLoginError.Visibility = ShowUserLogin ? Visibility.Collapsed : Visibility.Visible;
            txtPassword.Visibility = ShowUserLogin ? Visibility.Visible : Visibility.Collapsed;
            txtUsername.Visibility = ShowUserLogin ? Visibility.Visible : Visibility.Collapsed;
            btnLogin.Content = ShowUserLogin ? UIConstants.LOGIN : UIConstants.RETRY;
            if (ShowUserLogin)
                txtUsername.Focus();
        }

        /// <summary>
        /// Validate method authenticates the user credentials agains the database. It also does the empty field validation.
        /// </summary>
        /// <returns>A Bool value representing Authentication success or failure.</returns>
        private bool Validate()
        {
            if (string.IsNullOrEmpty(txtUsername.Text) || string.IsNullOrEmpty(txtPassword.Password))
            {
                return false;
            }
            else
            {
                UserAccount currentAccount = UserAccountBL.GetItem(Guid.Empty, txtUsername.Text.Trim(), ValidationUtility.EncryptPassword(txtPassword.Password.Trim()), string.Empty, DateTime.MinValue, DateTime.MinValue);
                if (currentAccount != null && currentAccount.UserRoleType.Trim().ToLower() != "user")
                {
                    AppSession.CurrentAdminUser = currentAccount;
                    return true;
                }
                else
                {
                    return false;
                }
            }
        }
        #endregion

        private void txtUsername_KeyUp(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.Enter)
                txtPassword.Focus();
        }

        private void txtPassword_KeyUp(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.Enter)
                btnLogin_Click(sender, new RoutedEventArgs());
        }
    }
}
